/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.TreeObj;
import cds.aladin.TreeObjDir;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DirectoryModel
extends DefaultTreeModel {
    protected DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
    private Aladin aladin;
    private HashMap<String, DefaultMutableTreeNode> fastAccess = null;

    protected DirectoryModel(Aladin aladin) {
        super(new DefaultMutableTreeNode(new TreeObj(aladin, "root", null, "Collections", "")));
        this.aladin = aladin;
    }

    protected int populateFlagIn() {
        return this.populateFlagIn(this.root);
    }

    private int populateFlagIn(DefaultMutableTreeNode node) {
        TreeObj treeObj = (TreeObj)node.getUserObject();
        if (treeObj.isHidden && node.isLeaf()) {
            return -2;
        }
        if (node.isLeaf()) {
            return treeObj.getIsIn();
        }
        DefaultMutableTreeNode subNode = null;
        Enumeration<TreeNode> e = node.children();
        int rep = -2;
        while (e.hasMoreElements()) {
            subNode = (DefaultMutableTreeNode)e.nextElement();
            int isIn = this.populateFlagIn(subNode);
            if (isIn == -2) continue;
            if (rep == -2) {
                rep = isIn;
                continue;
            }
            if (isIn == 1) {
                rep = isIn;
                continue;
            }
            if (isIn != -1 || rep != 0) continue;
            rep = isIn;
        }
        treeObj.setIn(rep);
        return rep;
    }

    protected int countDescendance() {
        return this.countDescendance(null);
    }

    protected int countDescendance(HashMap<String, Integer> hs) {
        if (this.root.isLeaf()) {
            return 0;
        }
        int nb = this.countDescendance(this.root.toString(), this.root, hs);
        return nb;
    }

    private int countDescendance(String prefix, DefaultMutableTreeNode parent, HashMap<String, Integer> hs) {
        TreeObj to = (TreeObj)parent.getUserObject();
        if (parent.isLeaf()) {
            return 1;
        }
        int n = 0;
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            n += this.countDescendance(prefix, node, hs);
        }
        if (hs != null) {
            hs.put(to.path, n);
            to.nb = to.nbRef = n;
        } else {
            to.nb = n;
        }
        return n;
    }

    protected void resetCreate() {
        this.fastAccess = new HashMap();
    }

    private void memoFast(DefaultMutableTreeNode node) {
        TreeObj to = (TreeObj)node.getUserObject();
        this.fastAccess.put(to.path, node);
    }

    private DefaultMutableTreeNode findFast(String path) {
        return this.fastAccess.get(path);
    }

    protected void createTreeBranch(TreeObj treeObj) {
        if (this.createWithExistingParent(treeObj)) {
            return;
        }
        DefaultMutableTreeNode[] nodeUp = new DefaultMutableTreeNode[1];
        int[] index = new int[1];
        DefaultMutableTreeNode lastParentNode = this.createTreeBranch(this, this.root, treeObj, 0, nodeUp, index);
        if (lastParentNode != null) {
            this.memoFast(lastParentNode);
        }
    }

    private boolean createWithExistingParent(TreeObj treeObj) {
        int pos = this.lastSlash(treeObj.path);
        if (pos == -1) {
            return true;
        }
        String path = treeObj.path.substring(0, pos);
        DefaultMutableTreeNode node = this.findFast(path);
        if (node == null) {
            return false;
        }
        node.add(new DefaultMutableTreeNode(treeObj));
        return true;
    }

    private int lastSlash(String s) {
        return s.lastIndexOf(47);
    }

    private DefaultMutableTreeNode createTreeBranch(DefaultTreeModel model, DefaultMutableTreeNode parent, TreeObj treeObj, int opos, DefaultMutableTreeNode[] parentUp, int[] childIndex) {
        int pos;
        int offset = opos;
        do {
            offset = pos = treeObj.path.indexOf(47, offset);
            if (pos > 1 && treeObj.path.charAt(pos - 1) == '\\') {
                ++offset;
                continue;
            }
            offset = -1;
        } while (offset != -1);
        String label = pos < 0 ? treeObj.path.substring(opos) : treeObj.path.substring(opos, pos);
        String path = pos < 0 ? treeObj.path : treeObj.path.substring(0, pos);
        ((TreeObj)parent.getUserObject()).noCheckbox();
        try {
            DefaultMutableTreeNode subNode = null;
            Enumeration<TreeNode> e = parent.children();
            while (e.hasMoreElements()) {
                subNode = (DefaultMutableTreeNode)e.nextElement();
                TreeObj fils = (TreeObj)subNode.getUserObject();
                if (label.equals(fils.label)) break;
                subNode = null;
            }
            if (subNode == null) {
                subNode = pos == -1 ? new DefaultMutableTreeNode(treeObj) : new DefaultMutableTreeNode(new TreeObj(this.aladin, "", null, label, path));
                TreeObj pere = (TreeObj)parent.getUserObject();
                if (pere != null && pere instanceof TreeObjDir) {
                    if (Aladin.levelTrace >= 3) {
                        System.err.println("Directory tree clash on " + pere.path + " (supposed to be a leaf, and in fact a node)");
                    }
                    DefaultMutableTreeNode pereNode = new DefaultMutableTreeNode(pere);
                    parent.add(pereNode);
                    parent.setUserObject(new TreeObj(this.aladin, "", null, pere.label, pere.path));
                }
                parent.add(subNode);
            }
            if (pos != -1) {
                return this.createTreeBranch(model, subNode, treeObj, pos + 1, parentUp, childIndex);
            }
            return parent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

